/**
 * Welcome to Cloudflare Workers! This is your first worker.
 *
 * - Run `npm run dev` in your terminal to start a development server
 * - Open a browser tab at http://localhost:8787/ to see your worker in action
 * - Run `npm run deploy` to publish your worker
 *
 * Bind resources to your worker in `wrangler.jsonc`. After adding bindings, a type definition for the
 * `Env` object can be regenerated with `npm run cf-typegen`.
 *
 * Learn more at https://developers.cloudflare.com/workers/
 */

export async function onRequest({ request, env }) {
	const url = new URL(request.url);
	if (url.pathname === "/proxy") {
		if (request.method === "HEAD") {
			return new Response(null, { status: 204 });
		}
		const targetUrl = url.searchParams.get("url");
		if (!targetUrl) {
			return new Response("Missing url parameter", { status: 400 });
		}
		try {
			const init = {
				method: request.method,
				headers: request.headers,
			};

			if (request.method === "POST") {
				init.body = await request.text();
			}

			const response = await fetch(targetUrl, init);
			const contentType =
				response.headers.get("Content-Type") ||
				"application/octet-stream";
			const body = await response.arrayBuffer();
			return new Response(body, {
				headers: { "Content-Type": contentType },
			});
		} catch (error) {
			return new Response("Error fetching target URL", { status: 500 });
		}
	} else {
		return new Response("Not found", { status: 404 });
	}
}
