'use strict';
{
	const sites = [
		'www.heraldsun.com.au',
		'www.couriermail.com.au',
		'www.dailytelegraph.com.au',
		'www.adelaidenow.com.au',
		'www.news.com.au',
		'www.theaustralian.com.au',
		'www.themercury.com.au',
		'www.geelongadvertiser.com.au',
		'www.cairnspost.com.au',
		'www.goldcoastbulletin.com.au',
		'www.townsvillebulletin.com.au',
		'www.thechronicle.com.au',
		'www.ntnews.com.au',
		'www.weeklytimesnow.com.au',
		'www.codesports.com.au',
	];

	const articleInput = document.getElementById('article');
	function bypassPaywall() {
		const articleButton = document.getElementById('article-button');
		let paywalledUrl = URL.canParse(articleInput.value) ? new URL(articleInput.value) : null;
		if (paywalledUrl !== null && paywalledUrl.pathname.startsWith('/subscribe/')) {
			let dest = decodeURIComponent(paywalledUrl.searchParams.get('dest') || '');
			if (URL.canParse(dest)) {
				paywalledUrl = new URL(dest);
			} else {
				paywalledUrl = null;
			}
		}
		if (paywalledUrl !== null && sites.includes(paywalledUrl.hostname)) {
			articleButton.href = `${paywalledUrl.protocol}//${paywalledUrl.hostname}${paywalledUrl.pathname.replace('/news-story/', '/news-story%2F')}`;
			articleButton.classList.remove('btn-dark', 'disabled');
			articleButton.classList.add('btn-secondary');
			articleInput.classList.remove('is-invalid');
		} else {
			articleButton.href = '#';
			articleButton.classList.remove('btn-secondary');
			articleButton.classList.add('btn-dark', 'disabled');
			articleInput.classList.add('is-invalid');
		}
	}
	articleInput.addEventListener('input', bypassPaywall);
}
{
	// These IDs were taken from 'https://www.<domain>/digitalprinteditions' and can be found in the network tab
	const publications = {
		'Herald Sun': ['6999fbfa-8731-4751-9865-d734ef946dd5', 'todayspaper.heraldsun.com.au'],
		'The Courier-Mail': ['fa4990cd-f3f7-44f1-b539-93cefe6dc9ba', 'todayspaper.couriermail.com.au'],
		'The Daily Telegraph': ['dde75240-0b81-4293-8932-a79e4be0d8f3', 'todayspaper.dailytelegraph.com.au'],
		'The Advertiser': ['47f7f236-9e2a-4745-afd2-b537892dba3c', 'todayspaper.adelaidenow.com.au'],
		'The Australian': ['2a462ce2-e442-4538-b39c-ba3d0caea663', 'todayspaper.theaustralian.com.au'],
		'The Mercury': ['d74a87e0-0097-4ad2-95f4-32970b7d0877', 'todayspaper.themercury.com.au'],
		'Geelong Advertiser': ['b00c95e7-c253-4d90-b0ed-914e76b6338e', 'todayspaper.geelongadvertiser.com.au'],
		'Cairns Post': ['af2998c9-4770-4f1c-abd3-65f4c38891b2', 'todayspaper.cairnspost.com.au'],
		'Gold Coast Bulletin': ['eb95481e-f26b-467a-a5d8-147a36d8f49c', 'todayspaper.goldcoastbulletin.com.au'],
		'Townsville Bulletin': ['0136ca7e-a3a0-41e2-bdca-aaece1c34f5b', 'todayspaper.townsvillebulletin.com.au'],
		'Toowoomba Chronicle': ['73dbe676-3a93-47aa-86de-8a0ef49f457b', 'todayspaper.thechronicle.com.au'],
		'NT News': ['0b7ea474-9ee3-45ae-86d3-731fff8b6be6', 'todayspaper.ntnews.com.au'],
		'The Weekly Times': ['cd56001a-57de-4401-96d9-67f1032f0203', 'todayspaper.weeklytimesnow.com.au'],
	};
	let publication = null;

	// We need to proxy the fetch requests to hide the referrer/origin headers
	// CORS is allowed so the requests will work without it, but this prevents identification
	// You can also swap this out for a different CORS proxy if you're self-hosting
	let corsProxy = 'https://api.cors.lol/?url=';

	// If the Cloudflare Worker is working, we can use that instead.
	fetch('/proxy', {
		method: 'HEAD',
	}).then(() => {
		corsProxy = '/proxy?url=';
	});

	function proxyFetch(input, init) {
		let url = typeof input === 'string' ? input : input.url;
		return fetch(corsProxy + encodeURIComponent(url), init);
	}

	const publicationSelect = document.getElementById('newspaper');

	// The website only requests 100 back issues, lets default to that as an attempt to blend in
	let backIssueCount = 100;

	function download(e, pubid, eid) {
		// These requests were observed in an unrelated pagesuite 'sample copy'
		e.target.disabled = true;
		e.target.textContent = 'Downloading...';
		proxyFetch(
			`https://${publication[1]}/html5/reader/get_page_groups_from_eid.aspx?pubid=${pubid}&eid=${eid}&version=production&device=desktop`,
		)
			.then((response) => response.json())
			.then((data) => {
				console.log(data);
				let xml = document.implementation.createDocument(null, null);
				let root = xml.createElement('pages');
				root.setAttribute('fromEdition', eid);
				data.pageGroups.forEach((group) => {
					group.pages.forEach((page) => {
						let pageEl = xml.createElement('page');
						pageEl.setAttribute('id', page.guid);
						root.appendChild(pageEl);
					});
				});
				xml.appendChild(root);
				let serializer = new XMLSerializer();
				let xmlString = serializer.serializeToString(xml);
				proxyFetch(`https://${publication[1]}/html5/Queue_PDF.aspx`, {
					method: 'POST',
					headers: {
						'Content-Type': 'application/xml',
					},
					body: xmlString,
				})
					.then((response) => response.text())
					.then((queueXml) => {
						let xmlUrl = new DOMParser().parseFromString(queueXml, 'application/xml');
						let downloadUrl = xmlUrl.querySelector('download:root>pdf').textContent;
						// This dodgy workaround removes the referrer
						let a = document.createElement('a');
						a.href = downloadUrl;
						a.rel = 'noreferrer';
						a.referrerPolicy = 'no-referrer';
						a.target = '_blank';
						a.className = 'd-none';
						document.body.appendChild(a);
						a.click();
						document.body.removeChild(a);
						e.target.disabled = false;
						e.target.classList.remove('btn-danger');
						e.target.classList.add('btn-primary');
						e.target.textContent = 'Download';
					});
			})
			.catch((error) => {
				console.error('Error fetching edition data:', error);
				e.target.disabled = false;
				e.target.classList.add('btn-danger');
				e.target.classList.remove('btn-primary');
				e.target.textContent = 'Error, try again?';
			});
	}

	function buildCard(img, title, pubid, eid) {
		const col = document.createElement('div');
		col.className = 'col';
		const card = document.createElement('div');
		card.className = 'card text-white bg-dark mb-3';
		const imgEl = document.createElement('img');
		imgEl.className = 'card-img-top';
		imgEl.src = img;
		imgEl.referrerPolicy = 'no-referrer';
		imgEl.loading = 'lazy';
		const cardBody = document.createElement('div');
		cardBody.className = 'card-body';
		const cardTitle = document.createElement('h5');
		cardTitle.className = 'card-title';
		cardTitle.textContent = title;
		const downloadButton = document.createElement('button');
		downloadButton.className = 'btn btn-primary';
		downloadButton.textContent = 'Download';
		downloadButton.onclick = (e) => download(e, pubid, eid);
		cardBody.appendChild(cardTitle);
		cardBody.appendChild(downloadButton);
		card.appendChild(imgEl);
		card.appendChild(cardBody);
		col.appendChild(card);
		return col;
	}

	function loadPublication() {
		publication = publications[publicationSelect.value];
		if (!publication) {
			console.error('Selected publication not found');
			return;
		}
		const [group_guid, host] = publication;
		// This URL was taken from 'https://www.couriermail.com.au/digitalprinteditions' and can be found in the network tab
		proxyFetch(
			`https://live.portal.pagesuite.com/api/endpoint/get_group_editions.aspx?groupGUID=${group_guid}&hostOverride=${host}&mainHeight=1000&othersHeight=600&backIssuesCount=${backIssueCount <= 365 ? backIssueCount : 100}`,
		)
			.then((response) => response.json())
			.then((data) => {
				console.log(data);
				document.getElementById('newspapers').classList.remove('d-none');
				let mainPaper = document.getElementById('main-paper');
				mainPaper.querySelector('img').src = data.main.thumbnail;
				mainPaper.querySelector('button').onclick = (e) => download(e, data.main.publicationGUID, data.main.editionGUID);

				const backIssues = document.getElementById('backissues');
				backIssues.innerHTML = '';
				// The get_group_editions.aspx endpoint seems limited to 365, we have to use editionsdesktop_json.aspx for more
				if (backIssueCount <= 365) {
					data.backIssues.forEach((issue) => {
						const card = buildCard(issue.thumbnail, issue.editionName, issue.publicationGUID, issue.editionGUID);
						backIssues.appendChild(card);
					});
				} else {
					// This URL was taken from an unrelated pagesuite 'sample copy'
					proxyFetch(
						`https://${host}/html5/editionsdesktop_json.aspx?publicationguid=${data.main.publicationGUID}&maxnumber=${backIssueCount}&version=production`,
					)
						.then((response) => response.json())
						.then((editionsData) => {
							editionsData?.editions?.edition?.forEach((issue) => {
								const card = buildCard(
									`https://${host}/get_image.aspx?eid=${issue['@editionguid']}&h=600`,
									issue['@name'],
									data.main.publicationGUID,
									issue['@editionguid'],
								);
								backIssues.appendChild(card);
							});
						});
				}
			})
			.catch((error) => {
				console.error('Error fetching publication data:', error);
				document.getElementById('newspapers').classList.add('d-none');
				document.getElementById('error').classList.remove('d-none');
			});
	}
	publicationSelect.addEventListener('change', () => {
		backIssueCount = 100;
		document.getElementById('more').disabled = false;
		loadPublication();
	});
	document.getElementById('more').addEventListener('click', (e) => {
		switch (backIssueCount) {
			case 100:
				backIssueCount = 365;
				break;
			case 365:
				backIssueCount = 900;
				break;
			case 900:
				// 24 years is probably enough, maybe increase in the future
				// Also hoping this blends in with 900, if a human is looking through the requests
				backIssueCount = 9000;
				e.target.disabled = true;
				break;
			default:
				backIssueCount = 100;
				break;
		}
		loadPublication();
	});
}
